# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Create a new device channel
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL for the SharePoint site
$webUrl = "http://sharepoint/site"

# Name and Alias for the device channel
$channelName = "PowerShell"

# Description for the device channel
$channelDescription = "PowerShell Channel"

# Inclusion rules for the device channel, use `n to insert a line break
$inclusionRules = "Android`niPad`niPod`niPhone`nBlackBerry`nIEMobile`nWebOS"

# Active state for the device channel
$active = $true

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the SharePoint site
$web = Get-SPWeb $webUrl

# Get the Device Channels list
$list = $web.Lists["Device Channels"]

# Add a new item to the list
$item = $list.Items.Add()

# Set the Name, Alias, and Description
$item["Name"] = $channelName
$item["Alias"] = $channelName
$item["Description"] = $channelDescription

# Set the Inclusion Rules.  Each inclusion rule needs to be on its own line in the field.  Using the `n escape character we can add a line break.
$item["Device Inclusion Rules"] = $inclusionRules

# Set the Active to true or false
$item["Active"] = $active

# Update the item
$item.Update()

# Dispose of the site object
$web.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# --------------------------------------------------------